% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{notebooks_put}
\alias{notebooks_put}
\title{Replace all attributes of this Notebook}
\usage{
notebooks_put(
  id,
  name = NULL,
  language = NULL,
  description = NULL,
  file_id = NULL,
  requirements_file_id = NULL,
  requirements = NULL,
  docker_image_name = NULL,
  docker_image_tag = NULL,
  instance_type = NULL,
  memory = NULL,
  cpu = NULL,
  credentials = NULL,
  environment_variables = NULL,
  idle_timeout = NULL,
  partition_label = NULL,
  git_repo_url = NULL,
  git_ref = NULL,
  git_path = NULL
)
}
\arguments{
\item{id}{integer required. The ID for this notebook.}

\item{name}{string optional. The name of this notebook.}

\item{language}{string optional. The kernel language of this notebook ("python3" or "r"). Defaults to "python3".}

\item{description}{string optional. The description of this notebook.}

\item{file_id}{string optional. The file ID for the S3 file containing the .ipynb file.}

\item{requirements_file_id}{string optional. The file ID for the S3 file containing the requirements.txt file.}

\item{requirements}{string optional. The requirements txt file.}

\item{docker_image_name}{string optional. The name of the docker image to pull from DockerHub.}

\item{docker_image_tag}{string optional. The tag of the docker image to pull from DockerHub (default: latest).}

\item{instance_type}{string optional. The EC2 instance type to deploy to.}

\item{memory}{integer optional. The amount of memory allocated to the notebook.}

\item{cpu}{integer optional. The amount of cpu allocated to the the notebook.}

\item{credentials}{array optional. A list of credential IDs to pass to the notebook.}

\item{environment_variables}{list optional. Environment variables to be passed into the Notebook.}

\item{idle_timeout}{integer optional. How long the notebook will stay alive without any kernel activity.}

\item{partition_label}{string optional. The partition label used to run this object.}

\item{git_repo_url}{string optional. The URL of the git repository (e.g., https://github.com/organization/repo_name.git).}

\item{git_ref}{string optional. The git reference if git repo is specified}

\item{git_path}{string optional. The path to the .ipynb file in the git repo that will be started up on notebook launch}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for this notebook.}
\item{name}{string, The name of this notebook.}
\item{language}{string, The kernel language of this notebook ("python3" or "r"). Defaults to "python3".}
\item{description}{string, The description of this notebook.}
\item{notebookUrl}{string, Time-limited URL to get the .ipynb file for this notebook.}
\item{notebookPreviewUrl}{string, Time-limited URL to get the .htm preview file for this notebook.}
\item{requirementsUrl}{string, Time-limited URL to get the requirements.txt file for this notebook.}
\item{fileId}{string, The file ID for the S3 file containing the .ipynb file.}
\item{requirementsFileId}{string, The file ID for the S3 file containing the requirements.txt file.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{dockerImageName}{string, The name of the docker image to pull from DockerHub.}
\item{dockerImageTag}{string, The tag of the docker image to pull from DockerHub (default: latest).}
\item{instanceType}{string, The EC2 instance type to deploy to.}
\item{memory}{integer, The amount of memory allocated to the notebook.}
\item{cpu}{integer, The amount of cpu allocated to the the notebook.}
\item{createdAt}{string, }
\item{updatedAt}{string, }
\item{mostRecentDeployment}{list, A list containing the following elements: 
\itemize{
\item deploymentId integer, The ID for this deployment.
\item userId integer, The ID of the owner.
\item host string, Domain of the deployment.
\item name string, Name of the deployment.
\item dockerImageName string, The name of the docker image to pull from DockerHub.
\item dockerImageTag string, The tag of the docker image to pull from DockerHub (default: latest).
\item displayUrl string, A signed URL for viewing the deployed item.
\item instanceType string, The EC2 instance type requested for the deployment.
\item memory integer, The memory allocated to the deployment, in MB.
\item cpu integer, The cpu allocated to the deployment, in millicores.
\item state string, The state of the deployment.
\item stateMessage string, A detailed description of the state.
\item maxMemoryUsage number, If the deployment has finished, the maximum amount of memory used during the deployment, in MB.
\item maxCpuUsage number, If the deployment has finished, the maximum amount of cpu used during the deployment, in millicores.
\item createdAt string, 
\item updatedAt string, 
\item notebookId integer, The ID of the owning Notebook
}}
\item{credentials}{array, A list of credential IDs to pass to the notebook.}
\item{environmentVariables}{list, Environment variables to be passed into the Notebook.}
\item{idleTimeout}{integer, How long the notebook will stay alive without any kernel activity.}
\item{partitionLabel}{string, The partition label used to run this object.}
\item{gitRepoId}{integer, The ID of the git repository.}
\item{gitRepoUrl}{string, The URL of the git repository (e.g., https://github.com/organization/repo_name.git).}
\item{gitRef}{string, The git reference if git repo is specified}
\item{gitPath}{string, The path to the .ipynb file in the git repo that will be started up on notebook launch}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{archived}{string, The archival status of the requested item(s).}
\item{hidden}{boolean, The hidden status of the item.}
}
\description{
Replace all attributes of this Notebook
}
