% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_post_api_keys}
\alias{users_post_api_keys}
\title{Create a new API key belonging to the logged-in user}
\usage{
users_post_api_keys(id, expires_in, name, constraints = NULL)
}
\arguments{
\item{id}{string required. The ID of the user or 'me'.}

\item{expires_in}{integer required. The number of seconds the key should last for.}

\item{name}{string required. The name of the API key.}

\item{constraints}{array optional. An array containing the following fields: 
\itemize{
\item constraint string, The path matcher of the constraint.
\item constraintType string, The type of constraint (exact/prefix/regex/verb).
\item getAllowed boolean, Whether the constraint allows GET requests.
\item headAllowed boolean, Whether the constraint allows HEAD requests.
\item postAllowed boolean, Whether the constraint allows POST requests.
\item putAllowed boolean, Whether the constraint allows PUT requests.
\item patchAllowed boolean, Whether the constraint allows PATCH requests.
\item deleteAllowed boolean, Whether the constraint allows DELETE requests.
}}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of the API key.}
\item{name}{string, The name of the API key.}
\item{expiresAt}{string, The date and time when the key expired.}
\item{createdAt}{string, The date and time when the key was created.}
\item{revokedAt}{string, The date and time when the key was revoked.}
\item{lastUsedAt}{string, The date and time when the key was last used.}
\item{scopes}{array, The scopes which the key is permissioned on.}
\item{useCount}{integer, The number of times the key has been used.}
\item{expired}{boolean, True if the key has expired.}
\item{active}{boolean, True if the key has neither expired nor been revoked.}
\item{constraints}{array, An array containing the following fields: 
\itemize{
\item constraint string, The path matcher of the constraint.
\item constraintType string, The type of constraint (exact/prefix/regex/verb).
\item getAllowed boolean, Whether the constraint allows GET requests.
\item headAllowed boolean, Whether the constraint allows HEAD requests.
\item postAllowed boolean, Whether the constraint allows POST requests.
\item putAllowed boolean, Whether the constraint allows PUT requests.
\item patchAllowed boolean, Whether the constraint allows PATCH requests.
\item deleteAllowed boolean, Whether the constraint allows DELETE requests.
}}
\item{token}{string, The API key.}
}
\description{
Create a new API key belonging to the logged-in user
}
