% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_abw.R
\name{calc_abw}
\alias{calc_abw}
\title{Calculate adjusted body weight (ABW)}
\usage{
calc_abw(weight = NULL, ibw = NULL, factor = 0.4, verbose = TRUE, ...)
}
\arguments{
\item{weight}{actual body weight in kg}

\item{ibw}{ideal body weight in kg}

\item{factor}{weighting factor, commonly 0.4 or 0.3}

\item{verbose}{show output?}

\item{...}{parameters passed to ibw function (if `ibw` not specified)}
}
\value{
adjusted body weight in kg
}
\description{
Often used for chemotherapy calculations when actual weight > 120% of IBW.
Adjusted body weight is returned in units of kg.
}
\examples{
calc_abw(weight = 80, ibw = 60)
calc_abw(weight = 80, height = 160, sex = "male", age = 60)
}
