% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pct_height_for_age.R
\name{pct_height_for_age}
\alias{pct_height_for_age}
\title{Percentile height for age for children}
\usage{
pct_height_for_age(
  age = NULL,
  height = NULL,
  sex = NULL,
  return_median = FALSE,
  ...
)
}
\arguments{
\item{age}{age in years}

\item{height}{height in kg. Optional, if specified, will calculate closest percentile and return in list as `percentile`}

\item{sex}{either `male` or `female`}

\item{return_median}{just return the median expected value}

\item{...}{parameters passed to `read_who_table()`}
}
\description{
Based on tables from WHO: http://www.who.int/childgrowth/standards/height_for_age/en/
}
\examples{
pct_height_for_age(age = 5, sex = "female")
pct_height_for_age(age = 5, height = 112, sex = "female")
}
