% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_utils.R
\name{cloud_drive_spreadsheet_autofit}
\alias{cloud_drive_spreadsheet_autofit}
\title{Automatically resize all columns in a google spreadsheet}
\usage{
cloud_drive_spreadsheet_autofit(file, root = NULL)
}
\arguments{
\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
The file ID of the resized Google spreadsheet as an invisible result.
}
\description{
Finds the spreadsheet by path relative to a project root.
Applies \code{\link[googlesheets4:range_autofit]{googlesheets4::range_autofit()}} to each sheet.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cloud_drive_write(mtcars, "results/mtcars.xlsx")
cloud_drive_spreadsheet_autofit("results/mtcars.xlsx")
\dontshow{\}) # examplesIf}
}
