% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_inference.R
\name{get_cormat}
\alias{get_cormat}
\title{A fast function to calculate correlation matrix (LD matrix) from individual level data}
\usage{
get_cormat(X, intercepte = TRUE)
}
\arguments{
\item{X}{A matrix of individual level data.}

\item{intercepte}{A logical value indicating whether to include an intercept in the model. Default is FALSE.}
}
\value{
A correlation matrix (LD matrix).
}
\description{
This function calculates the correlation matrix (LD matrix) from individual level data.
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
cormat <- get_cormat(X)

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cos}()},
\code{\link{get_cos_purity}()},
\code{\link{get_cos_summary}()},
\code{\link{get_hierarchical_clusters}()},
\code{\link{get_ucos_summary}()}
}
\concept{colocboost_utilities}
\keyword{cb_post_inference}
