% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_imports.R, R/table_methods.R,
%   R/volume_methods.R
\name{list_content_cnt}
\alias{list_content_cnt}
\alias{list_content_cnt.ConnectorDatabricksTable}
\alias{list_content_cnt.ConnectorDatabricksVolume}
\title{List available content from the connector}
\usage{
list_content_cnt(connector_object, ...)

\method{list_content_cnt}{ConnectorDatabricksTable}(connector_object, ..., tags = NULL)

\method{list_content_cnt}{ConnectorDatabricksVolume}(connector_object, ...)
}
\arguments{
\item{connector_object}{\link[connector]{Connector} The connector object to use.}

\item{...}{\link{ConnectorDatabricksVolume}: Additional parameters to pass to the
\code{\link[brickster:db_volume_list]{brickster::db_volume_list()}} method}

\item{tags}{Expression to be translated to SQL using
\code{\link[dbplyr:translate_sql]{dbplyr::translate_sql()}} e.g.
\code{((tag_name == "name1" && tag_value == "value1") || (tag_name == "name2"))}.
It should contain \code{tag_name} and \code{tag_value} values to filter by.}
}
\value{
A \link{character} vector of content names
}
\description{
Additional list content methods for Databricks connectors implemented for
\code{\link[connector:list_content_cnt]{connector::list_content_cnt()}}:

\itemize{
\item \link{ConnectorDatabricksTable}: Reuses the \code{\link[connector:list_content_cnt]{connector::list_content_cnt()}}
method for \link{ConnectorDatabricksTable}, but always
sets the \code{catalog} and \code{schema} as defined in when initializing the
connector.
}

\itemize{
\item \link{ConnectorDatabricksVolume}: Reuses the \code{\link[connector:list_content_cnt]{connector::list_content_cnt()}}
method for \link{ConnectorDatabricksVolume}, but always
sets the \code{catalog}, \code{schema} and \code{path} as defined in when initializing the
connector.
}
}
