% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thrstThrsh.R
\name{itemListToThresholds}
\alias{itemListToThresholds}
\title{itemListToThresholds}
\usage{
itemListToThresholds(
  myItems,
  threshP = 0.5,
  minTheta = -20,
  maxTheta = 20,
  convC = 1e-05
)
}
\arguments{
\item{myItems}{A list of item parameter matricies of the structure used in \code{simplef}
(a matrix of k categories by four (category score, delta dot, tau, discrimination)).}

\item{threshP}{The probability at which the thresholds are calculated (defaults to the usual value of 0.5)}

\item{minTheta}{The lower-bound starting value of the split-half search used to find the threshold for the category.}

\item{maxTheta}{The upper-bound starting value of the split-half search used to find the threshold for the category.}

\item{convC}{The convergence criteria used to determine when the threshold has been found. The difference between
\code{threshP} and the cumulative probability of the category and any higher category at the current value of theta
(the current proposed value of threshold being tested).}
}
\value{
A data frame including 4 columns:
\itemize{
\item id, an integer index reflecting which item this is, in the same order as myItems
\item itemid, a string with the names from the items in myItems (NA if item list is not named)
\item step, which step does this threshold belong?
\item location, the value of the threshold
}
}
\description{
Taskes a list of item parameter matricies and returns a data frame containing
Thurstonian Thresholds (\emph{gammas}) for all items.
Thurstonian thresholds are the location on the trait/scale at which the cumulative probability
of being in category k, or any higher category equals some probability (usually 0.5, the default).
Thurstonian thresholds are considered a way of describing the difficulty of polytomously scored
items and are usually the value used in visualisations like Wright maps.
Thurstonian thresholds can only be calculated for items where response categories are scored such
that each category can be placed in an order increasing scores (e.g., no ties as per the Ordered Partition model)
}
\examples{
myItem <- matrix(
  c(
    0, -0.58    ,  0     , 1,  # delta+tau   thurst thresh (gamma)
    1, -0.58    ,  0.776 , 1,  # 0.196       -1.14
    2, -0.58    , -0.697 , 1,  # -1.277      -0.93
    3, -0.58    , -0.629 , 1,  # -1.209      -0.64
    4, -0.58    ,  0.55  , 1   # -0.03        0.25
    ), ncol =4, byrow=TRUE
 )
itemListToThresholds(list(myItem))
}
