# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Conversion of parameters alpha, beta and gamma to pnk, pak and pck
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: should the covariate information be used? default: False
#' @return pik matrix of priors: pnk, pak and pck
pars2pik <- function(params, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_pars2pik`, params, nsnps, covar_vec, covar)
}

#' Log sum
#' @param x vector of log scale values to be added
#' @return log sum of input
logsumexp <- function(x) {
    .Call(`_cophescan_logsumexp`, x)
}

#' Log posterior calculation
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: should the covariate inflormation be used? default: False
#' @return logpost flog of the posteriors
logpost <- function(params, lbf_mat, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_logpost`, params, lbf_mat, nsnps, covar_vec, covar)
}

#' Log likelihood calculation
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: should the covariate inflormation be used? default: False
#' @return logpost flog of the posteriors
loglik <- function(params, lbf_mat, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_loglik`, params, lbf_mat, nsnps, covar_vec, covar)
}

#' Calculation of the posterior prob of Hn, Ha and Hc
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: should the covariate inflormation be used? default: False
#' @return posterior prob of Hn, Ha and Hc
get_posterior_prob <- function(params, lbf_mat, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_get_posterior_prob`, params, lbf_mat, nsnps, covar_vec, covar)
}

#' sample alpha
#' @param alpha_mean prior for the mean of  alpha
#' @param alpha_sd prior for the standard deviation of  alpha
#' @return sample from rnorm for \eqn{\alpha}
sample_alpha <- function(alpha_mean = -10, alpha_sd = 0.5) {
    .Call(`_cophescan_sample_alpha`, alpha_mean, alpha_sd)
}

#' sample beta
#' @param beta_shape prior for the shape (gamma distibution) of beta
#' @param beta_scale prior for the scale of beta
#' @return sample from rgamma for \eqn{\beta}
sample_beta <- function(beta_shape = 2, beta_scale = 2) {
    .Call(`_cophescan_sample_beta`, beta_shape, beta_scale)
}

#' sample gamma
#' @param gamma_shape prior for the shape (gamma distibution) of gamma
#' @param gamma_scale prior for the scale of gamma
#' @return sample from rgamma for \eqn{\gamma}
sample_gamma <- function(gamma_shape = 2, gamma_scale = 2) {
    .Call(`_cophescan_sample_gamma`, gamma_shape, gamma_scale)
}

#' dnorm for alpha
#' @param a current alpha
#' @param alpha_mean prior for the mean of  alpha
#' @param alpha_sd prior for the standard deviation of  alpha
#' @return log dnorm
logd_alpha <- function(a, alpha_mean = -10, alpha_sd = 0.5) {
    .Call(`_cophescan_logd_alpha`, a, alpha_mean, alpha_sd)
}

#' dgamma for beta
#' @param b current beta
#' @param beta_shape prior for the shape (gamma distibution) of beta
#' @param beta_scale prior for the scale of beta
#' @return log dgamma
logd_beta <- function(b, beta_shape = 2, beta_scale = 2) {
    .Call(`_cophescan_logd_beta`, b, beta_shape, beta_scale)
}

#' dgamma for gamma
#' @param g current gamma
#' @param gamma_shape prior for the shape (gamma distibution) of gamma
#' @param gamma_scale prior for the scale of gamma
#' @return log dgamma
logd_gamma <- function(g, gamma_shape = 2, gamma_scale = 2) {
    .Call(`_cophescan_logd_gamma`, g, gamma_shape, gamma_scale)
}

#' Calculate log priors
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param covar logical: Should the covariate inflormation be used? default: False
#' @param alpha_mean prior for the mean of  alpha
#' @param alpha_sd prior for the standard deviation of  alpha
#' @param beta_shape prior for the shape (gamma distibution) of beta
#' @param beta_scale prior for the scale of beta
#' @param gamma_shape prior for the shape (gamma distibution) of gamma
#' @param gamma_scale prior for the scale of gamma
#' @return log priors
logpriors <- function(params, covar = FALSE, alpha_mean = -10, alpha_sd = 0.5, beta_shape = 2, beta_scale = 2, gamma_shape = 2, gamma_scale = 2) {
    .Call(`_cophescan_logpriors`, params, covar, alpha_mean, alpha_sd, beta_shape, beta_scale, gamma_shape, gamma_scale)
}

#' Target distribution
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: Should the covariate inflormation be used? default: False
#' @return target
target <- function(params, lbf_mat, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_target`, params, lbf_mat, nsnps, covar_vec, covar)
}

#' Proposal distribution
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param propsd Standard deviation for the proposal
#' @return vector : proposal
propose <- function(params, propsd = 0.5) {
    .Call(`_cophescan_propose`, params, propsd)
}

#' Initiate parameters alpha, beta and gamma
#' @param covar logical: Should the covariate inflormation be used? default: False
#' @param alpha_mean prior for the mean of  alpha
#' @param alpha_sd prior for the standard deviation of  alpha
#' @param beta_shape prior for the shape (gamma distibution) of beta
#' @param beta_scale prior for the scale of beta
#' @param gamma_shape prior for the shape (gamma distibution) of gamma
#' @param gamma_scale prior for the scale of gamma
#' @return params \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
pars_init <- function(covar = FALSE, alpha_mean = -10, alpha_sd = 0.5, beta_shape = 2, beta_scale = 2, gamma_shape = 2, gamma_scale = 2) {
    .Call(`_cophescan_pars_init`, covar, alpha_mean, alpha_sd, beta_shape, beta_scale, gamma_shape, gamma_scale)
}

#' Run the hierarchical mcmc model to infer priors
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param nits Number of iterations run in mcmc
#' @param thin thinning
#' @param covar logical: Should the covariate inflormation be used? default: False
#' @param alpha_mean prior for the mean of  alpha
#' @param alpha_sd prior for the standard deviation of  alpha
#' @param beta_shape prior for the shape (gamma distibution) of beta
#' @param beta_scale prior for the scale of beta
#' @param gamma_shape prior for the shape (gamma distibution) of gamma
#' @param gamma_scale prior for the scale of gamma
#' @return named list of log likelihood (ll) and parameters: alpha, beta and gamma
metrop_run <- function(lbf_mat, nsnps, covar_vec, covar = FALSE, nits = 10000L, thin = 1L, alpha_mean = -10, alpha_sd = 0.5, beta_shape = 2, beta_scale = 2, gamma_shape = 2, gamma_scale = 2) {
    .Call(`_cophescan_metrop_run`, lbf_mat, nsnps, covar_vec, covar, nits, thin, alpha_mean, alpha_sd, beta_shape, beta_scale, gamma_shape, gamma_scale)
}

#' List of posterior probabilities: Hn, Ha and Hc over all iterations
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return List of posterior probabilties (len: iterations): Hn, Ha and Hc
posterior_prob <- function(params, lbf_mat, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_posterior_prob`, params, lbf_mat, nsnps, covar_vec, covar)
}

#' List of priors: pn, pa and pc over all iterations
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return List of priors (len: iterations): pnk, pak and pck
piks <- function(params, nsnps, covar_vec, covar = FALSE) {
    .Call(`_cophescan_piks`, params, nsnps, covar_vec, covar)
}

#' Average of posterior probabilities: Hn, Ha and Hc from list (memory intensive)
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param nits Number of iterations run in mcmc
#' @param thin thinning
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return matrix with average of all the posterior probabilities: Hn, Ha and Hc
average_posterior_prob_list <- function(params, lbf_mat, nsnps, covar_vec, nits, thin, covar = FALSE) {
    .Call(`_cophescan_average_posterior_prob_list`, params, lbf_mat, nsnps, covar_vec, nits, thin, covar)
}

#' Average of posterior probabilities: Hn, Ha and Hc
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param lbf_mat matrix of log bayes factors: lBF.Ha and lBF.Hc
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param nits Number of iterations run in mcmc
#' @param thin thinning
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return matrix with average of all the posterior probabilities: Hn, Ha and Hc
average_posterior_prob <- function(params, lbf_mat, nsnps, covar_vec, nits, thin, covar = FALSE) {
    .Call(`_cophescan_average_posterior_prob`, params, lbf_mat, nsnps, covar_vec, nits, thin, covar)
}

#' Average of priors: pnk, pak and pck from list (memory intensive)
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param nits Number of iterations run in mcmc
#' @param thin thinning
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return average pik matrix of priors: pnk, pak and pck
average_piks_list <- function(params, nsnps, covar_vec, nits, thin, covar = FALSE) {
    .Call(`_cophescan_average_piks_list`, params, nsnps, covar_vec, nits, thin, covar)
}

#' Average of priors: pnk, pak and pck
#'
#' @param params Vector of parameters: \eqn{\alpha}, \eqn{\beta} and \eqn{\gamma}
#' @param nsnps number of snps
#' @param covar_vec Vector of the covariate
#' @param nits Number of iterations run in mcmc
#' @param thin thinning
#' @param covar logical: was the covariate inflormation  used? default: False
#' @return average pik matrix of priors: pnk, pak and pck
average_piks <- function(params, nsnps, covar_vec, nits, thin, covar = FALSE) {
    .Call(`_cophescan_average_piks`, params, nsnps, covar_vec, nits, thin, covar)
}

