% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crcal.R
\name{crystMW}
\alias{crystMW}
\title{Relative Crystallinity Calculation of X-Ray Diffraction Pattern of Starch by Bruckner Method}
\usage{
crystMW(pattern, N = 41, iter = 100)
}
\arguments{
\item{pattern}{matrix. The matrix of X-ray diffraction pattern.  The first row corresponds to Bragg angle 2\eqn{\theta}; the second row corresponds to intensity.}

\item{N}{numeric. N length of the smoothing window (number of variables). Defaults to 41.}

\item{iter}{numeric. Iter number of iterations. Defaults to 100.}
}
\value{
An object of class crystMW, which is a list with the following components:
  \item{original}{Original matrix of X-ray diffraction patterns.}
  \item{background}{Estimation of the background shape (curve of the amorphous starch).}
  \item{corrected}{Estimation of residual crystalline area (curve of the crystalline starch).}
  \item{summary}{Summary calculation of crystallinity. Total area under the curve of the diffraction pattern (A.U.); Amorphous area (A.U.); Crystalline area (A.U.); Relative crystallinity (\%).}
}
\description{
Allow  to calculate the relative crystallinity of starch by XRD.
The basic concept of Bruckner approach involves obtaining a smoothed
line that separates the amorphous and crystalline starch of an X-ray
diffraction pattern. This smoothed line is achieved by applying
a moving average smoothing method to the original pattern.
}
\details{
Calculate the relative starch crystallinity of XRD pattern by Bruckner method.
}
\examples{
data(XRD)
# Convert data frame to matrix, select A-type starch
pattern <- as.matrix(t(XRD[,c("Bragg_angle","A")]))
# List of crystallinity components
crs <- crystMW(pattern, N = 41, iter = 100)
# Original matrix
original <- crs$original
# Background shape
background <- crs$background
# Curve of the crystalline starch
corrected <- crs$corrected
# Summary calculation of crystallinity
summary <- crs$summary
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}
\references{
Bruckner, S. (2000). "Estimation of the background in powder diffraction patterns through a robust smoothing procedure." Journal of Applied Crystallography 33(3 Part 2): 977-979.
}

