% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_chemical_mrv}
\alias{get_chemical_mrv}
\title{Get mrv file by DTXSID or DTXCID}
\usage{
get_chemical_mrv(
  DTXSID = NULL,
  DTXCID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{DTXCID}{The chemical identifier DTXCID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
XML file format for representing a mrv file.
}
\description{
Get mrv file by DTXSID or DTXCID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull mrv file for BPA by dtxsid
bpa_mrv <- get_chemical_mrv(DTXSID = 'DTXSID7020182')
# Pull mrv file for BPA by dtxcid
bpa_mrv <- getchemical_mrv(DTXCID = 'DTXCID30182')
\dontshow{\}) # examplesIf}
}
