% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_dp}
\alias{get_dp}
\title{Deviation from Proportionality}
\usage{
get_dp(
  cf,
  host_weights,
  codon_table = get_codon_table(),
  level = "subfam",
  missing_action = "ignore"
)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by \code{count_codons()}.}

\item{host_weights}{a named vector of tRNA weights for each codon that reflects the relative
availability of tRNAs in the host organism.}

\item{codon_table}{a table of genetic code derived from \code{get_codon_table} or
\code{create_codon_table}.}

\item{level}{"subfam" (default) or "amino_acid". If "subfam", the deviation is calculated at
the codon subfamily level. Otherwise, the deviation is calculated at the amino acid level.}

\item{missing_action}{Actions to take when no codon of a group were found in a CDS. Options are
"ignore" (default), or "zero" (set codon proportions to 0).}
}
\value{
a named vector of dp values. The names of the elements correspond to the sequence names.
}
\description{
\code{get_dp} calculates Deviation from Proportionality of each CDS.
}
\examples{
# estimate DP of yeast genes
cf_all <- count_codons(yeast_cds)
trna_weight <- est_trna_weight(yeast_trna_gcn)
trna_weight <- setNames(trna_weight$w, trna_weight$codon)
dp <- get_dp(cf_all, host_weights = trna_weight)
head(dp)
hist(dp)

}
\references{
Chen F, Wu P, Deng S, Zhang H, Hou Y, Hu Z, Zhang J, Chen X, Yang JR. 2020.
  Dissimilation of synonymous codon usage bias in virus-host coevolution due to translational
  selection. Nat Ecol Evol 4:589-600.
}
