% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoenc_conv_ed.R
\name{autoenc_conv_ed}
\alias{autoenc_conv_ed}
\title{Convolutional Autoencoder - Encode-Decode}
\usage{
autoenc_conv_ed(
  input_size,
  encoding_size,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001
)
}
\arguments{
\item{input_size}{input size}

\item{encoding_size}{encoding size}

\item{batch_size}{size for batch learning}

\item{num_epochs}{number of epochs for training}

\item{learning_rate}{learning rate}
}
\value{
A \code{autoenc_conv_ed} object.
}
\description{
Creates a deep learning convolutional autoencoder (ConvAE) to encode and decode
sequences of observations. Wraps a PyTorch implementation.
}
\examples{
\dontrun{
X <- matrix(rnorm(1000), nrow = 50, ncol = 20)
ae <- autoenc_conv_ed(input_size = 20, encoding_size = 5, num_epochs = 50)
ae <- daltoolbox::fit(ae, X)
X_hat <- daltoolbox::transform(ae, X)  # same dims as X
mean((X - X_hat)^2)
}

# See:
# https://github.com/cefet-rj-dal/daltoolbox/blob/main/transf/autoenc_conv_ed.md
}
