% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.monomorphs.r
\name{gl.report.monomorphs}
\alias{gl.report.monomorphs}
\title{Reports monomorphic loci}
\usage{
gl.report.monomorphs(x, verbose = NULL)
}
\arguments{
\item{x}{Name of the input genlight object [required].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default NULL, unless specified using gl.set.verbosity].}
}
\value{
An unaltered genlight object
}
\description{
This script reports the number of monomorphic loci and those with all NAs in
a genlight \{adegenet\} object
}
\details{
A DArT dataset will not have monomorphic loci, but they can arise, along with
loci that are scored all NA, when populations or individuals are deleted.
Retaining monomorphic loci unnecessarily increases the size of the dataset
and will affect some calculations.
Note that for SNP data, NAs likely represent null alleles; in tag
presence/absence data, NAs represent missing values (presence/absence could
not be reliably scored)
}
\examples{
# SNP data
  gl.report.monomorphs(testset.gl)
# SilicoDArT data
  gl.report.monomorphs(testset.gs)
}
\seealso{
\code{\link{gl.filter.monomorphs}}

Other matched reports: 
\code{\link{gl.mahal.assign}()},
\code{\link{gl.report.bases}()},
\code{\link{gl.report.factorloadings}()},
\code{\link{gl.report.fstat}()}
}
\author{
Custodian: Arthur Georges -- Post to
 \url{https://groups.google.com/d/forum/dartr}
}
\concept{matched reports}
