% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.taglength.r
\name{gl.report.taglength}
\alias{gl.report.taglength}
\title{Reports summary of sequence tag length across loci}
\usage{
gl.report.taglength(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP [required].}

\item{plot.display}{If TRUE, histograms of base composition are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5", "#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory in which to save files [default = working directory]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity]}
}
\value{
Returns unaltered genlight object
}
\description{
SNP datasets generated by DArT typically have sequence tag lengths ranging
from 20 to 69 base pairs. This function reports summary statistics of the tag
 lengths.
}
\details{
This function reports sequence tag lengths for a genlight object. It is a companion
function to \code{\link{gl.filter.taglength}} which can be used to filter out 
loci with a tag length less than a specified threshold.
The table of quantiles is useful for deciding a threshold for subsequent filtering
as it provides an indication of the percentages of loci that will be retained and 
lost. 
\strong{ Function's output }
 The minimum, maximum, mean and a tabulation of tag length quantiles against
 thresholds are output to the console. The output also includes a boxplot and a
 histogram to guide in the selection of a threshold for filtering on tag
 length.
 
If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.
 If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir(). 
 
To avoid issues from inadvertent use of this function in an assignment statement,
the function returns the genlight object unaltered.
}
\examples{
out <- gl.report.taglength(testset.gl)

}
\seealso{
\code{\link{gl.filter.taglength}}

Other matched report: 
\code{\link{gl.filter.excess.het}()},
\code{\link{gl.report.allna}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.secondaries}()}
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched report}
