% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sort.r
\name{gl.sort}
\alias{gl.sort}
\title{Sorts genlight objects}
\usage{
gl.sort(x, sort.by = "pop", order.by = NULL, verbose = NULL)
}
\arguments{
\item{x}{Genlight object containing SNP/Silicodart genotypes [required].}

\item{sort.by}{Specify to sort the genotypes by either 'ind', "pop" [default 'pop'].}

\item{order.by}{Vector used to order genotypes [default NULL]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
Returns a reordered genlight object. Sorts also the ind/loc.metrics 
and coordinates accordingly
}
\description{
This function provides the ability to sort genotypes in a genlight object by  
individual name or population name.
}
\details{
This is a function to sort genotypes in a genlight object by individual name
or population name. This will be useful if you want to visualise the structure
across populations (bands) in a gl.smearplot; order of genotypes is important.

The order.by parameter needs to be a vector upon which to effect the sort, of length of 
nPop(gl) if sort.by is 'pop' or  nInd(gl) if sort.by is 'ind'.  For sort.by='ind' 
order.by can be a vector such as a variable in gl@other$ind.metrics.

If not specified by nominating a vector with order.by, alphabetical order of populations or individuals is used.
}
\examples{
#sort by populations
bc <- gl.sort(bandicoot.gl)
#sort from West to East
bc2 <- gl.sort(bandicoot.gl, sort.by="pop" ,
order.by=c("WA", "SA", "VIC", "NSW", "QLD"))
#sort by missing values
miss <- rowSums(is.na(as.matrix(bandicoot.gl)))
bc3 <- gl.sort(bandicoot.gl, sort.by="ind", order.by=miss)
gl.smearplot(bc3)
}
\seealso{
Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.edit.recode.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Bernd Gruber (Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{data manipulation}
