% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valestamod.r
\name{valestamod}
\alias{valestamod}
\title{Function to create a table with the prediction statistics
by model.}
\usage{
valestamod(
  data = data,
  y.obs = "y.obs",
  y.pred = "y.pred",
  model = "model",
  want.by.valcl = FALSE,
  val.class = NA,
  want.all.outputs = FALSE
)
}
\arguments{
\item{data}{a dataframe having the predicted and observed values
of the response variable for a set of models.}

\item{y.obs}{a character giving the column name of the response
variable for the data.}

\item{y.pred}{a character giving the column name of the predicted
value for the response variable giving the predictor(s)
variable(s) values for the data and the respective fitted model.}

\item{model}{a character giving the column name for the name of
previously fitted model(s).}

\item{want.by.valcl}{A logical option for requesting to also
computed the prediction statistics by validation classes, which
are stored in the column defined in \code{val.class}. By default is set
to \code{FALSE}.}

\item{val.class}{If validation classes were assigned to each
observation, this option corresponds to character giving the
column name of the validation class. By default this option
is set to \code{NA}, meaning is not available.}

\item{want.all.outputs}{A logical option to save a full set of result elements
in the output, thus the output is class \code{list}. By default is set
to \code{FALSE}.}
}
\value{
The main output is a table having as number of rows the
total number of fitted models, and number of columns the
statistics being computed. By default the statistics implemented
in the \code{valesta()} function are computed.
}
\description{
Creates a table with the prediction statistics for
previously fitted models, based on the observed data.
}
\details{
The function computes prediction statistics for a
previously fitted model, and prepare an output summarizing the
results to facilitate the comparison among models.
}
\examples{

#Creates a fake dataframe
set.seed(1234);
Y=rnorm(30, 30,9);X=rnorm(30, 450,133); Z=rbeta(30, .1,2)
df <- as.data.frame(cbind(Y, X,Z))
## Fitting some models
mod1 <- lm(Y~X, data=df)
mod2 <- lm(Y~X+I(X^2), data=df)
mod3 <- lm(Y~Z+I(X^2), data=df)
## Preparing the format of the input-data for the function
df.m1<-df.m2<-df.m3<-df
df.m1$model<-"mod1";df.m1$y.aju=fitted(mod1)
df.m2$model<-"mod2";df.m2$y.aju=fitted(mod2)
df.m3$model<-"mod3";df.m3$y.aju=fitted(mod3)
dfypredmod<-rbind(df.m1,df.m2,df.m3)
head(dfypredmod)
table(dfypredmod$model)
# Example
valestamod(data=dfypredmod,y.obs="Y",y.pred="y.aju")
}
\references{
\itemize{
\item Salas C. 2002. Ajuste y validación de ecuaciones de volumen para un
relicto del bosque de roble-laurel-lingue.
Bosque 23(2):81–92. \doi{10.4067/S0717-92002002000200009}.
}
}
\author{
Christian Salas-Eljatib and Marcos Marivil.
}
