% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RatingTables.R
\name{GetRatingTableFromJobId}
\alias{GetRatingTableFromJobId}
\title{Get a rating table from the rating table job metadata.}
\usage{
GetRatingTableFromJobId(project, ratingTableJobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{ratingTableJobId}{integer. The job ID returned by \code{CreateRatingTable}.}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the retrieve to complete.}
}
\value{
An S3 object of class 'dataRobotRatingTable' summarizing all
  available information about the rating table.
}
\description{
Get a rating table from the rating table job metadata.
}
\examples{
\dontrun{
   projectId <- "5984b4d7100d2b31c1166529"
   modelId <- "5984b4d7100d2b31c1166529"
   ratingTableJobId <- CreateRatingTable(projectId, modelId, dataSource = "myRatingTable.csv")
   GetRatingTableFromJobId(projectId, ratingTableJobId)
}
}
