% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfusionChart.R
\name{ListConfusionCharts}
\alias{ListConfusionCharts}
\title{Returns all available confusion charts for the model.}
\usage{
ListConfusionCharts(model, fallbackToParentInsights = FALSE)
}
\arguments{
\item{model}{dataRobotModel. A DataRobot model object like that returned by \code{GetModel}.}

\item{fallbackToParentInsights}{logical. If TRUE, this will return the lift chart data for the
model's parent if the lift chart is not available for the model and the model has a parent
model.}
}
\value{
A list of all confusion charts for the model, one for each partition type
  found in \code{DataPartition}.
}
\description{
Note that the confusion chart for \code{source = "crossValidation"} will not be available
unless cross validation has been run for that model. Also, the confusion chart
for \code{source = "holdout"} will not be available unless the holdout has been unlocked for
the project.
}
\examples{
\dontrun{
  modelId <- "5996f820af07fc605e81ead4"
  ListConfusionCharts(modelId)
}
}
