% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defined.R
\name{defined}
\alias{defined}
\alias{is.defined}
\alias{summary.haven_labelled_defined}
\title{Create a semantically well-defined, labelled vector}
\usage{
defined(
  x,
  labels = NULL,
  label = NULL,
  unit = NULL,
  concept = NULL,
  namespace = NULL,
  ...
)

is.defined(x)

\method{summary}{haven_labelled_defined}(object, ...)
}
\arguments{
\item{x}{A vector of type character, numeric, Date, factor, or a \code{labelled}
object.}

\item{labels}{An optional named vector of value labels. Only a subset of
values may be labelled.}

\item{label}{A short human-readable label (string of length 1).}

\item{unit}{Unit of measurement (e.g., "kg", "hours"). Must be a string of
length 1 or \code{NULL}.}

\item{concept}{A URI or concept name representing the meaning of the
variable.}

\item{namespace}{Optional string or named character vector, used for
value-level URI expansion.}

\item{...}{Reserved for future use.}

\item{object}{An R object to be summarised.}
}
\value{
A vector of class \code{"defined"} (technically
\code{haven_labelled_defined}), which behaves like a standard vector with
additional semantic metadata and is inherited from \code{\link[haven:labelled]{haven::labelled()}}.
}
\description{
\code{defined()} constructs a vector enriched with semantic metadata such as a
label, unit of measurement, concept URI, and optional namespace.
These vectors behave like base R vectors but retain metadata during
subsetting, comparison, and printing.
}
\details{
The resulting object inherits from \code{\link[haven:labelled]{haven::labelled()}} and integrates with
tidyverse workflows, enabling downstream conversion to RDF and other
standards.
}
\examples{
gdp_vector <- defined(
  c(3897, 7365, 6753),
  label = "Gross Domestic Product",
  unit = "million dollars",
  concept = "http://data.europa.eu/83i/aa/GDP"
)

# To check the s3 class of the vector:
is.defined(gdp_vector)

# To print the defined vector:
print(gdp_vector)

# To summarise the defined vector:
summary(gdp_vector)

# Subsetting work as expected:
gdp_vector[1:2]
}
\seealso{
\code{browseVignettes("dataset")}

\code{\link[=is.defined]{is.defined()}}, \code{\link[=as_numeric]{as_numeric()}}, \code{\link[=as_character]{as_character()}}, \code{\link[=as_factor]{as_factor()}},
\code{\link[=strip_defined]{strip_defined()}}
}
