% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahalanobis.R
\name{mahalanobisDistance}
\alias{mahalanobisDistance}
\title{Mahalanobis Distance}
\usage{
mahalanobisDistance(ecl, X, lambda, center = FALSE)
}
\arguments{
\item{ecl}{estimate of covariance/correlation matrix from \code{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{X}{data matrix}

\item{lambda}{specify lambda and override value from ‘ecl’}

\item{center}{logical: should columns be centered internally}
}
\value{
array of distances
}
\description{
Mahalanobis Distance using \code{eclairs()} decomposition
}
\details{
Evaluate quadratic form \eqn{(X-\mu)^T \Sigma^{-1} (X-\mu)} where covariance is estimated from finite sample
}
\examples{
library(Rfast)

n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)

# eclairs decomposition
ecl <- eclairs(Y)

# Mahalanobis distance after mean centering
Y_center <- scale(Y, scale = FALSE)
mu <- colMeans(Y)

# Standard R method
a <- mahalanobis(Y, mu, cov = cov(Y))

# distance using eclairs decomposition, no shrinage
b <- mahalanobisDistance(ecl, Y_center, lambda = 0)
range(a - b)

# with shrinkage
d <- mahalanobisDistance(ecl, Y_center)

# centering internally
e <- mahalanobisDistance(ecl, Y, center = TRUE)
range(d - e)
#
}
