% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon_frag.R
\name{shannon_frag}
\alias{shannon_frag}
\title{Shannon diversity decomposition}
\usage{
shannon_frag(x, gx, f, gf)
}
\arguments{
\item{x}{Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.}

\item{gx}{Vector of dimension S of factors indicating the groups. G groups.}

\item{f}{Vector of dimension G with the number (>0) of fragments in each group}

\item{gf}{Vector of dimension G of factors indicating the groups of f.}
}
\value{
\itemize{
  \item \code{shannon}: Shannon's total Entropy.
  \item \code{within}: Within groups entropy.
  \item \code{between}: Between groups entropy.
  \item \code{groups}: A data frame with information about each group: relative frequency, internal entropy and number of spicies.
}
}
\description{
Computes Shannon diversity and its decomposition
}
\examples{
data(Qesem_s)
data(Qesem_f)
shannon_frag(Qesem_s$HU, Qesem_s$Group, Qesem_f$HU, Qesem_f$Group)

}
\references{
"Arnaud Barat, Andreu Sansó, Maite Arilla-Osuna, Ruth Blasco, Iñaki Pérez-Fernández, Gabriel Cifuentes-Alcobenda, Rubén Llorente, Daniel Vivar-Ríos, Ella Assaf, Ran Barkai, Avi Gopher, & Jordi Rosell-Ardèvol (2025): Quantifying Diversity through Entropy Decomposition. Insights into Hominin Occupation and Carcass Processing  at Qesem cave"
}
\seealso{
\link{shannon}
}
