% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dixon.R
\encoding{UTF-8}
\name{Dixon}
\alias{Dixon}
\alias{qdixon}
\alias{pdixon}
\alias{ddixon}
\alias{rdixon}
\title{Dixon distribution}
\usage{
qdixon(p, n, i = 1, j = 1, log.p = FALSE, lower.tail = TRUE)

pdixon(q, n, i = 1, j = 1, lower.tail = TRUE, log.p = FALSE)

ddixon(x, n, i = 1, j = 1, log = FALSE)

rdixon(n, i = 1, j = 1)
}
\arguments{
\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required}

\item{i}{number of observations <= x_i}

\item{j}{number of observations >= x_j}

\item{log.p}{logical; if \code{TRUE} propabilities p are given as log(p)}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are P[X <= x] otherwise, P[X > x].}

\item{q}{vector of quantiles}

\item{x}{vector of quantiles.}

\item{log}{logical; if \code{TRUE} (default),
probabilities p are given as log(p).}
}
\value{
\code{ddixon} gives the density function,
\code{pdixon} gives the distribution function,
\code{qdixon} gives the quantile function and
\code{rdixon} generates random deviates.
}
\description{
Density, distribution function, quantile function
and random generation for Dixon's ratio statistics \eqn{r_{j,i-1}}{r[j,i-1]}
for outlier detection.
}
\details{
According to McBane (2006) the density of the statistics \eqn{r_{j,i-1}}{r[j,i-1]} of Dixon
can be yield if \eqn{x} and \eqn{v} are integrated over the range \eqn{(-\infty < x < \infty, 0 \le v < \infty)}

\deqn{
\begin{array}{lcl}
f(r) & = & \frac{n!}{\left(i-1\right)! \left(n-j-i-1\right)!\left(j-1\right)!} \\
      & & \times \int_{-\infty}^{\infty} \int_{0}^{\infty} \left[\int_{-\infty}^{x-v} \phi(t)dt\right]^{i-1}
       \left[\int_{x-v}^{x-rv} \phi(t)dt \right]^{n-j-i-1} \\
     & &  \times \left[\int_{x-rv}^x \phi(t)dt \right]^{j-1} \phi(x-v)\phi(x-rv)\phi(x)v ~ dv ~ dx \\
\end{array}}{%
  f(r) = n! / [(i-1)! (n-j-i-1)! (j-1)!]  Int[-\infty,\infty] Int[0,\infty]
         [Int[-\infty,x-v] \phi(t)dt ] [Int[x-v,x-rv] \phi(t)dt]^(n-j-i-1)
         [Int[x-rv,x] \phi(t)dt]^(j-1) \phi(x-v)\phi(x-rv)\phi(x)v dv dx
}
where \eqn{v} is the Jacobian and \eqn{\phi(.)} is the density of the standard normal distribution.
McBane (2006) has proposed a numerical solution using Gaussian quadratures
(Gauss-Hermite quadrature and half-range Hermite quadrature) and coded
a library in Fortran. These R functions are wrapper functions to
use the respective Fortran code.
}
\note{
The file \file{slowTest/d-p-q-r-tests.R.out.save} that is included in this package
contains some results for the assessment of the numerical accuracy.

The slight numerical differences between McBane's original Fortran output
(see files \file{slowTests/test[1,2,4].ref.output.txt}) and
this implementation are related to different floating point rounding
algorithms between R (see \sQuote{round to even} in \code{\link[base]{round}})
and Fortran's \code{write(*,'F6.3')} statement.
}
\section{Source}{

The R code is a wrapper to the Fortran code released
under GPL >=2 in the electronic supplement of McBane (2006).
The original files are \file{rfuncs.f}, \file{utility.f} and \file{dixonr.fi}.
They were slightly modified to comply with current CRAN policy and the R manual
\sQuote{Writing R Extensions}.
}

\examples{
set.seed(123)
n <- 20
Rdixon <- rdixon(n, i = 3, j = 2)
Rdixon
pdixon(Rdixon, n = n, i = 3, j = 2)
ddixon(Rdixon, n = n, i = 3, j = 2)

}
\references{
Dixon, W. J. (1950) Analysis of extreme values.
\emph{Ann. Math. Stat.} \bold{21}, 488--506.
\doi{10.1214/aoms/1177729747}.

Dean, R. B., Dixon, W. J. (1951) Simplified statistics for small
numbers of observation. \emph{Anal. Chem.} \bold{23}, 636--638.
\doi{10.1021/ac60052a025}.

McBane, G. C. (2006) Programs to compute distribution functions
and critical values for extreme value ratios for outlier detection.
\emph{J. Stat. Soft.} \bold{16}.
\doi{10.18637/jss.v016.i03}.
}
\keyword{distribution}
