% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{normality}
\alias{normality}
\alias{normality.data.frame}
\alias{normality.grouped_df}
\title{Performs the Shapiro-Wilk test of normality}
\usage{
normality(.data, ...)

\method{normality}{data.frame}(.data, ..., sample = 5000)

\method{normality}{grouped_df}(.data, ..., sample = 5000)
}
\arguments{
\item{.data}{a data.frame or a \code{\link[tibble]{tbl_df}}.}

\item{...}{one or more unquoted expressions separated by commas.
You can treat variable names like they are positions.
Positive values select variables; negative values to drop variables.
If the first expression is negative, normality() will automatically start with all variables.
These arguments are automatically quoted and evaluated in a context where column names
represent column positions.
They support unquoting and splicing.}

\item{sample}{the number of samples to perform the test.

See vignette("EDA") for an introduction to these concepts.}
}
\value{
An object of the same class as .data.
}
\description{
The normality() performs Shapiro-Wilk test of normality of numerical values.
}
\details{
This function is useful when used with the \code{\link[dplyr]{group_by}}
function of the dplyr package. If you want to test by level of the categorical
data you are interested in, rather than the whole observation,
you can use group_tf as the group_by function.
This function is computed \code{\link{shapiro.test}} function.
}
\section{Normality test information}{

The information derived from the numerical data test is as follows.

\itemize{
\item statistic : the value of the Shapiro-Wilk statistic.
\item p_value : an approximate p-value for the test. This is said in
Roystion(1995) to be adequate for p_value < 0.1.
\item sample : the number of samples to perform the test.
The number of observations supported by the stats::shapiro.test function is 3 to 5000.
}
}

\examples{
# Normality test of numerical variables
normality(heartfailure)

# Select the variable to describe
normality(heartfailure, platelets, sodium, sample = 200)

# death_eventing dplyr::grouped_dt
library(dplyr)

gdata <- group_by(heartfailure, smoking, death_event)
normality(gdata, "platelets")
normality(gdata, sample = 250)

# Positive values select variables
heartfailure \%>\%
  normality(platelets, sodium)

# death_eventing pipes & dplyr -------------------------
# Test all numerical variables by 'smoking' and 'death_event',
# and extract only those with 'smoking' variable level is "No".
heartfailure \%>\%
  group_by(smoking, death_event) \%>\%
  normality() \%>\%
  filter(smoking == "No")

# extract only those with 'sex' variable level is "Male",
# and test 'platelets' by 'smoking' and 'death_event'
heartfailure \%>\%
  filter(sex == "Male") \%>\%
  group_by(smoking, death_event) \%>\%
  normality(platelets)

# Test log(platelets) variables by 'smoking' and 'death_event',
# and extract only p.value greater than 0.01.
heartfailure \%>\%
  mutate(platelets_income = log(platelets)) \%>\%
  group_by(smoking, death_event) \%>\%
  normality(platelets_income) \%>\%
  filter(p_value > 0.01)

}
\seealso{
\code{\link{normality.tbl_dbi}}, \code{\link{diagnose_numeric.data.frame}}, \code{\link{describe.data.frame}}, \code{\link{plot_normality.data.frame}}.
}
