% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_excluded}
\alias{p_excluded}
\title{Get the dtrackr excluded data record}
\usage{
p_excluded(.data, simplify = TRUE)
}
\arguments{
\item{.data}{a dataframe which may be grouped}

\item{simplify}{return a single summary dataframe of all exclusions.}
}
\value{
a new dataframe of the excluded data up to this point in the workflow. This dataframe is by default flattened, but if \code{.simplify=FALSE} has a nested structure containing records excluded at each part of the pipeline.
}
\description{
Get the dtrackr excluded data record
}
\examples{
library(dplyr)
library(dtrackr)
tmp = iris \%>\% track() \%>\% capture_exclusions()
tmp \%>\% exclude_all(
   Petal.Length > 5.8 ~ "{.excluded} long ones",
   Petal.Length < 1.3 ~ "{.excluded} short ones",
   .stage = "petal length exclusion"
) \%>\% excluded()
}
