% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_na.R
\name{ls_explicit_na}
\alias{ls_explicit_na}
\title{Encode Categorical Missing Values in a \code{list} of \code{data.frame}}
\usage{
ls_explicit_na(
  data,
  omit_tables = NULL,
  omit_columns = NULL,
  char_as_factor = TRUE,
  na_level = "<Missing>"
)
}
\arguments{
\item{data}{(\code{list} of \code{data.frame}) to be transformed.}

\item{omit_tables}{(\code{character}) the names of the tables to omit from processing.}

\item{omit_columns}{(\code{character}) the names of the columns to omit from processing.}

\item{char_as_factor}{(\code{logical}) should character columns be converted into factor.}

\item{na_level}{(\code{string}) the label to encode missing levels.}
}
\value{
\code{list} of \code{data.frame} object with explicit missing levels.
}
\description{
Encode Categorical Missing Values in a \code{list} of \code{data.frame}
}
\details{
This is a helper function to encode missing values (i.e \code{NA} and \verb{empty string}) of every \code{character} and
\code{factor} variable found in a \code{list} of \code{data.frame}. The \code{label} attribute of the columns is preserved.
}
\examples{
df1 <- data.frame(
  "char" = c("a", "b", NA, "a", "k", "x"),
  "char2" = c("A", "B", NA, "A", "K", "X"),
  "fact" = factor(c("f1", "f2", NA, NA, "f1", "f1")),
  "logi" = c(NA, FALSE, TRUE, NA, FALSE, NA)
)
df2 <- data.frame(
  "char" = c("a", "b", NA, "a", "k", "x"),
  "fact" = factor(c("f1", "f2", NA, NA, "f1", "f1")),
  "num" = c(1:5, NA)
)
df3 <- data.frame(
  "char" = c(NA, NA, "A")
)

db <- list(df1 = df1, df2 = df2, df3 = df3)

ls_explicit_na(db)
ls_explicit_na(db, omit_tables = "df3", omit_columns = "char2")

}
