% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,compare2-method}
\alias{nem_plot,compare2-method}
\title{Visualizing the results of multiple comparisons (two-factor)}
\usage{
\S4method{nem_plot}{compare2}(object, type1 = 1, type2 = 1, add, ...)
}
\arguments{
\item{object}{A \code{\link{compare2-class}} object.}

\item{type1}{\code{type1 = 1}, draws a box plot; \code{type1 = 2}, draws a bar plot.
Default \code{type1 = 1}.}

\item{type2}{\code{type2 = 1}, draw a cluster plot; \code{type2 = 2}, draws faceted plot.
Default \code{type2 = 1}.}

\item{add}{Add standard deviation or standard error (only used when drawing a
bar plot).}

\item{...}{Other parameters to be expanded.}
}
\value{
An \code{gg} or \code{ggplot} object.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{compare2-class}}
and is used to visualize the results of two-factor multiple comparisons.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_compare2(.group1 = con_crop, .group2 = season, y = pH, method = LSD) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem(tab = easynem_example("nemtab1.csv"),
                tax = easynem_example("nemtax1.csv"),
                meta = easynem_example("nemmeta1.csv"))
nem_plot <- nem |> calc_compare2(.group1 = con_crop,
                    .group2 = season, y = pH, method = LSD2) |>
                    nem_plot(type2 = 2)
nem_plot
nem_plot <- nem |> calc_compare2(.group1 = con_crop,
                    .group2 = season, y = pH, method = HSD2) |>
                    nem_plot(type1 = 2, type2 = 2, add = "mean_sd")
nem_plot
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
