% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{df_schema}
\alias{df_schema}
\title{Describe the schema of a data frame, suitable for sending to an LLM}
\usage{
df_schema(df, max_cols = 50)
}
\arguments{
\item{df}{A data frame to describe.}

\item{max_cols}{Maximum number of columns to includes. Defaults to 50 to
avoid accidentally generating very large prompts.}
}
\description{
\code{df_schema()} gives a column-by-column description of a data frame. For
each column, it gives the name, type, label (if present), and number of
missing values. For numeric and date/time columns, it also gives the
range. For character and factor columns, it also gives the number of unique
values, and if there's only a few (<= 10), their values.

The goal is to give the LLM a sense of the structure of the data, so that
it can generate useful code, and the output attempts to balance between
conciseness and accuracy.
}
\examples{
df_schema(mtcars)
df_schema(iris)
}
