% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movement.R
\name{movement}
\alias{movement}
\title{Analyze movement recorded within a nest with an accelerometer datalogger}
\usage{
movement(
  x = stop("data.frame must be provided"),
  col.time = "Time",
  col.x = "x",
  col.y = "y",
  col.z = "z",
  DaysQuiet = 40,
  SkipDays = 1,
  k = 4,
  Windowsize = 15
)
}
\arguments{
\item{x}{A data.frame with 4 columns, one for time and three for x, y, and z position}

\item{col.time}{Name of the column with time}

\item{col.x}{Name of the column with x positions}

\item{col.y}{Name of the column with y positions}

\item{col.z}{Name of the column with z positions}

\item{DaysQuiet}{Number of days in quiet period}

\item{SkipDays}{Number of days to skip before being in quiet mode}

\item{k}{Factor to multiply SD to prevent false positive detection}

\item{Windowsize}{Number of records used for moving average}
}
\value{
The function will return a data.frame
}
\description{
This function is used to evaluate significant movement within a nest.\cr
The "quiet" period is the period without any expected move. It is used as a reference
to detect the period with significant movements.\cr
It returns a data.frame with the columns:\cr
"Time", "x", "y", "z", \cr
"mvt", "mvt_standardized", "peakmvt", "running", "mvt_MA_standardized", \cr
"mvt_2", "mvt_2_standardized", "peakmvt_2", "running_2", "mvt_2_MA_standardized".\cr
mvt and mvt_2 are two different methods. Often mvt_2 is better to descrobe movments.\cr
}
\details{
movement is a function that permits to analyze movement datalogger
}
\examples{
\dontrun{
library(embryogrowth)
mv <- movement(x=dataf, 
               col.time="Time", 
               col.x="x", col.y="y", col.z="z")
}
}
\references{
\insertRef{11893}{embryogrowth}\cr
}
\seealso{
Other Data loggers utilities: 
\code{\link{calibrate.datalogger}()},
\code{\link{uncertainty.datalogger}()}
}
\author{
Marc Girondot
}
\concept{Data loggers utilities}
