% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_methods.R
\name{fixef}
\alias{fixef}
\alias{fixed.effects}
\alias{fixef.ebp}
\alias{fixed.effects.ebp}
\alias{fixef.fh}
\alias{fixed.effects.fh}
\title{Extract Fixed Effects from an emdi Object}
\usage{
\method{fixef}{ebp}(object, ...)

\method{fixed.effects}{ebp}(object, ...)

\method{fixef}{fh}(object, ...)

\method{fixed.effects}{fh}(object, ...)
}
\arguments{
\item{object}{an object of type "emdi", depending on the used method either
"ebp" or "fh".}

\item{...}{additional arguments that are not used in this method.}
}
\value{
For classes "ebp" and "fh" a vector containing the fixed effects is
returned.
}
\description{
Methods \code{fixef.ebp} and \code{fixef.fh} extract the
fixed effects from an emdi object of class "ebp" or "fh".
}
\details{
The alias \code{fixed.effects} can also be used instead of
\code{fixef}. The generic function \code{fixef} is imported from package
nlme and re-exported to make the S3-methods available, even though the nlme
package itself is not loaded or attached. For default documentation,
see \code{\link[nlme]{fixed.effects}}.
}
\examples{
\donttest{
# Example for class ebp
emdi_model <- ebp(
  fixed = eqIncome ~ gender + eqsize + cash + self_empl +
    unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow +
    house_allow + cap_inv + tax_adj, pop_data = eusilcA_pop,
  pop_domains = "district", smp_data = eusilcA_smp, smp_domains = "district",
  na.rm = TRUE
)

fixef(emdi_model)
}
}
\seealso{
\code{\link{ebp}}, \code{\link{fh}},
\code{\link[nlme]{fixed.effects}}
}
