% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hreal.R
\name{hreal}
\alias{hreal}
\alias{print.hreal}
\alias{summary.hreal}
\alias{as.matrix.hreal}
\title{Realization of Hawkes Process}
\usage{
\method{print}{hreal}(x, n = 20, ...)

\method{summary}{hreal}(object, n = 20, ...)

\method{as.matrix}{hreal}(x, ...)
}
\arguments{
\item{x}{An S3 object of class \code{hreal}.}

\item{n}{The number of rows to display.}

\item{...}{Additional arguments passed to or from other methods.}

\item{object}{An S3 object of class \code{hreal}.}
}
\description{
\code{hreal} is a list containing the following components:
\itemize{
\item \code{hspec}: An S4 object of class \code{\link{hspec-class}} that specifies the parameter values.
\item \code{inter_arrival}: The time intervals between consecutive events.
\item \code{arrival}: The cumulative sum of \code{inter_arrival} times.
\item \code{type}: An integer representing the type of event.
\item \code{mark}: The size of the mark, providing additional information associated with the event.
\item \code{N}: A counting process that tracks the number of events.
\item \code{Nc}: A counting process that tracks the number of events, weighted by mark.
\item \code{lambda}: The left-continuous intensity process.
\item \code{lambda_component}: The component of the intensity process, \eqn{\lambda_{ij}}, that excludes \code{mu}.
\item \code{rambda}: The right-continuous intensity process.
\item \code{rambda_component}: The right-continuous version of \code{lambda_component}.
}

Functions for printing \code{hreal} objects are provided.
}
