% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extremevalue.R
\name{return.level.est}
\alias{return.level.est}
\title{Return level estimation - Only intended for developer use}
\usage{
return.level.est(r, u, sigma_u, xi, lambda_u, theta)
}
\arguments{
\item{r}{a return period.}

\item{u}{a threshold value.}

\item{sigma_u}{a scale parameter of Generalized Pareto distribution.}

\item{xi}{a shape parameter of Generalized Pareto distribution.}

\item{lambda_u}{a relative frequency of the number of threshold value exceedances.}

\item{theta}{an extremal index.}
}
\value{
A numeric value of return lever corresponding to return period \code{r}
}
\description{
Estimation of return level for a given threshold value using Peaks Over Threshold model.
The function is called by \code{\link{KRDetect.outliers.EV}} and is not intended for use by regular users of the package.
}
\details{
This function computes the estimate of return level for a given threshold value using Peaks Over Threshold model.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function used within \code{\link{KRDetect.outliers.EV}}.
}
\references{
Coles S (2001). An Introduction to Statistical Modeling of Extreme Values. 3 edition. London: Springer. ISBN 1-85233-459-2.

Pickands J (1975). Statistical inference using extreme order statistics. The Annals of Statistics, 3(1), 119-131.
}
