test_that("assert_character_param", {
  expect_no_error(assert_character_param("name", "*"))
  expect_no_error(assert_character_param("name", "value", len = 1))
  expect_error(assert_character_param("name", c("value", "value"), len = 1))
  expect_no_error(assert_character_param("name", c("value1", "value2")))
  expect_error(assert_character_param("name", 5))
  expect_error(assert_character_param("name", NULL))
  expect_no_error(assert_character_param("name", NULL, required = FALSE))
  expect_error(assert_character_param("name", list("value1", 5)))
})

test_that("assert_integerish_param", {
  expect_no_error(assert_integerish_param("name", 5, len = 1))
  expect_error(assert_integerish_param("name", c(5, 6), len = 1))
  expect_no_error(assert_integerish_param("name", c(5, 6)))
  expect_error(assert_integerish_param("name", "value", len = 1))
  expect_error(assert_integerish_param("name", NULL, len = 1))
  expect_no_error(assert_integerish_param("name", NULL, len = 1, required = FALSE))
  expect_error(assert_integerish_param("name", list(5, 6)))
})

test_that("assert_date_param", {
  expect_no_error(assert_date_param("name", "*"))
  expect_no_error(assert_date_param("name", "2020-01-01", len = 1))
  expect_error(assert_date_param("name", c("2020-01-01", "2021-01-02"), len = 1))
  expect_no_error(assert_date_param("name", c("2020-01-01", "2021-01-02")))
  expect_no_error(assert_date_param("name", c(20200101, 20200101)))
  expect_no_error(assert_date_param("name", c(as.Date("2020-01-01"), as.Date("2020-01-02"))))
  expect_error(assert_date_param("name", NULL))
  expect_no_error(assert_date_param("name", NULL, required = FALSE))
  expect_error(assert_date_param("name", list(20200101, 20200101)))
})

test_that("assert_timeset_param", {
  # Make sure to keep in sync with test-model.R parse_timeset_input checks
  expect_no_error(assert_timeset_param("name", "*"))
  expect_no_error(assert_timeset_param("name", "2020-01-01", len = 1))
  expect_error(assert_timeset_param("name", c("2020-01-01", "2021-01-02"), len = 1))
  expect_no_error(assert_timeset_param("name", c("2020-01-01", "2021-01-02")))
  expect_no_error(assert_timeset_param("name", c(20200101, 20200101)))
  expect_no_error(assert_timeset_param("name", c(as.Date("2020-01-01"), as.Date("2020-01-02"))))
  expect_no_error(assert_timeset_param("name", epirange(20200101, 20200102)))
  expect_error(assert_timeset_param("name", c(epirange(20200101, 20200102), epirange(20200103, 20200104))))
  expect_error(assert_timeset_param("name", NULL))
  expect_no_error(assert_timeset_param("name", NULL, required = FALSE))
  expect_error(assert_timeset_param("name", list(epirange(20200101, 20200102), epirange(20200101, 20200102))))
  # Non-EpiRange-class epiranges are no longer allowed:
  expect_error(assert_timeset_param("name", list(from = "2020-01-01", to = "2021-01-02")))
  expect_error(assert_timeset_param("name", c(from = "2020-01-01", to = "2021-01-02")))
})
