% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqMI.RMSEA.R
\name{eqMI.RMSEA}
\alias{eqMI.RMSEA}
\title{Obtain the RMSEA cutoff values for equivalence testing}
\usage{
eqMI.RMSEA(N, m, df)
}
\arguments{
\item{N}{Total sample size of all groups}

\item{m}{Number of groups}

\item{df}{Degree of freedom}
}
\value{
The adjusted cutoff values corresponding to conventional cutoff values .01, .05, .08, and .10.
}
\description{
Generate adjusted cutoff values of RMSEA for equivalence testing corresponding to conventional cutoff values .01, .05, .08, and .10.
}
\details{
The adjusted cutoff values of RMSEA for equivalence testing can be obtained with \code{N, m, df} and transformed variables. Formulas are estimated using simulation studies and the coefficients are given in Table 11 of the reference.
}
\examples{
alpha <- .05;
N <- 200;
m <- 1;
T_ml <- 28.446; #the statistic T_ml for group 1;
df <- 24;
eqMI.RMSEA(N = N, m = m, df = df);

}
\references{
Steiger, J. H. (1980). Statistically based tests for the number of common factors. In the annual meeting of the Psychometric Society. Iowa City, IA.

Yuan, K. H., & Chan, W. (2016). Measurement invariance via multigroup SEM: Issues and solutions with chi-square-difference tests. Psychological methods, 21(3), 405-426.
}
