% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm_rank.R
\name{rank.edgecov-ergmTerm}
\alias{rank.edgecov-ergmTerm}
\alias{InitWtErgmTerm.rank.edgecov}
\title{Dyadic covariates}
\usage{
# valued: rank.edgecov(x, attrname)
}
\arguments{
\item{x, attrname}{a specification for the dyadic covariate: either
one of the following, or the name of a network attribute
containing one of the following: \describe{

\item{a covariate matrix}{with dimensions \eqn{n \times n}{n*n}
for unipartite networks and \eqn{b \times (n-b)}{b*(n-b)} for
bipartite networks; \code{attrname}, if given, is used to construct
the term name.}

\item{a network object}{with the same size and bipartitedness as
LHS; \code{attrname}, if given, provides the name of the
quantitative edge attribute to use for covariate values (in
this case, missing edges in \code{x} are assigned a covariate value
of zero).}

}}
}
\description{
Models the effect of a dyadic covariate on the propensity of an ego
\eqn{i} to rank alter \eqn{j} highly.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "rank.edgecov", "subsection")}
}
\concept{directed}
\concept{ordinal}
\concept{quantitative dyadic attribute}
\concept{valued}
