% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{evo_client}
\alias{evo_client}
\title{Create an Evolution API client}
\usage{
evo_client(base_url, api_key, instance)
}
\arguments{
\item{base_url}{Character. Server base URL (no trailing slash), e.g. \code{"https://your-host"}.}

\item{api_key}{Character. API key (sent as \code{apikey} header).}

\item{instance}{Character. Instance name/ID used in endpoint paths.}
}
\value{
An object of class \code{evo_client} with fields \code{req} (httr2 request) and \code{instance}.
}
\description{
Creates a preconfigured \strong{httr2} client to call Evolution API v2.
It sets the \code{apikey} header, a custom User-Agent and basic automatic retries.
}
\examples{
\dontrun{
client <- evo_client("https://evolution_api_host", "KEY", "chatArgus")
}
}
