% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_string.R
\name{as_string}
\alias{as_string}
\alias{lstring}
\alias{lobs}
\alias{as_obs}
\alias{as_sum}
\alias{as_fraction}
\alias{lfrac}
\title{Convert Vectors to Strings or Formatted Representations}
\usage{
as_string(txt, collapse = ", ", last = ", and ")

as_sum(txt)

as_obs(txt, name = "x", sorted = FALSE, ...)

as_fraction(val, latex = FALSE, sorted = FALSE, ...)

lobs(txt, name = "x", sorted = FALSE, ...)

lstring(txt, collapse = ", ", last = ", and ")

lfrac(val, latex = FALSE, sorted = FALSE, ...)
}
\arguments{
\item{txt}{Character vector to merge into a single string (used in \code{as_string}, \code{as_obs}).}

\item{collapse}{Character string inserted between elements (default: \code{", "}).}

\item{last}{Character string used between the last two elements (default: \code{", and "}).}

\item{name}{Character string used as the observation name (default: \code{"x"}; used in \code{as_obs}).}

\item{sorted}{Logical; if \code{TRUE}, sort the vector before conversion (default: \code{FALSE}).}

\item{...}{Additional arguments passed to underlying functions.}

\item{val}{Numeric vector of values to convert into fractions (used in \code{as_fraction}).}

\item{latex}{Logical; if \code{TRUE}, returns fractions in LaTeX format \code{\\frac{.}{.}} (default: \code{FALSE}; used in \code{as_fraction}).}
}
\value{
A single string, or a vector of formatted strings (for fractions in \code{as_fraction}).
}
\description{
These functions convert vectors into human-readable string representations.
They can join elements, create LaTeX-formatted fractions, or label observations.
}
\examples{
x <- runif(5)
y <- c(TRUE, FALSE, NA)

# Basic string conversion
as_string(x)
as_string(y)
as_string(as.character(x))
as_string(as.character(y))

# Observations
as_obs(x)
as_obs(sort(x), sorted = TRUE)

# Fraction conversion
x <- round(runif(5), 2)
as_fraction(x)
as_fraction(x, latex = TRUE)

# Summing elements as a string
y <- round(runif(5), 2)
as_sum(y)
}
