% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ts.R
\name{as_ts}
\alias{as_ts}
\title{Convert ts_data Object to Time Series}
\usage{
as_ts(ts)
}
\arguments{
\item{ts}{A \code{ts_data} object containing the time series values and structure.}
}
\value{
A \code{ts} object representing the same time series as the input \code{ts_data}.
}
\description{
Transforms a \code{ts_data} object into a standard R \code{ts} (time series) object.
}
\details{
The function preserves the original time indices and frequency of the input \code{ts_data}.
It calculates the \code{deltat} based on the time vector \code{t} in \code{ts_data}.
}
\examples{
# Create a ts_data object with a linear trend
ts_obj <- ts_data(12, trend.coeff = c(sample(0:10, 1), sample(1 + (1:10)/20, 1)))

# Convert to standard ts object
ts_standard <- as_ts(ts_obj)
}
