% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddiscrete2.R
\name{ddiscrete2}
\alias{ddiscrete2}
\alias{biv_discrete_prob}
\title{Bivariate Discrete Probability Function}
\usage{
ddiscrete2(
  row,
  col,
  unit = NULL,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)

biv_discrete_prob(
  row,
  col,
  unit = NULL,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)
}
\arguments{
\item{row}{numeric: marginal \code{row} distribution}

\item{col}{numeric: marginal \code{col} distribution}

\item{unit}{integer: reciprocal of the smallest non-zero probability (default: \code{NULL})}

\item{zero}{logical: zeros are allowed in the final probabilities (default: \code{FALSE})}

\item{FUN}{function: association or correlation function (default: \code{nom.cc})}

\item{target}{numeric: target association or correlation (default: \code{NA})}

\item{tol}{numeric: tolerance for target association or correlation (default: \code{0.001})}

\item{maxit}{integer: maximal number of iterations (default: \code{100})}

\item{...}{further parameters for \code{FUN}}
}
\value{
A bivariate discrete probability function.
}
\description{
Creates a bivariate discrete probability function based on the marginal probability functions
\code{row} and \code{col}. If \code{unit} is not given then \code{unit} will be the product of the units
used in \code{row} and \code{col}, otherwise it will appear as the least common multiple \code{unit} product of
the units used in \code{row} and \code{col}.
If \code{target} is \code{NA} then the common distribution of two independent random variables
is returned, otherwise an iterative algorithm is run to approach a \code{target} association or
correlation measure, see also \code{\link[=assoc_data]{assoc_data()}} (called internally).
\code{zero} allows for zero entries in the common distribution.
\code{FUN} computes the association or correlation measures based on a
frequency table. \code{tol} gives the maximal deviation of the association or correlation measure
and the \code{target} value. \code{maxit} limits the number of steps.
Please note that a solution is not guaranteed, especially for extreme values for \code{target}, for example
for \eqn{+1}, \eqn{-1} or nearby values.
If \code{attr(joint, "iterations")==maxit} then you need
either to increase \code{maxit}, to decrease \code{tol} or to check if you have chosen an
appropriate \code{target} value (for a nominal measure in \eqn{0 <= target <= 1}, for ordinal measure in \eqn{-1 <= target <= +1}).
}
\examples{
row <- ddiscrete(runif(5))
col <- ddiscrete(runif(3))
joint <- ddiscrete2(row, col)
joint
joint <- ddiscrete2(row, col, target=0.5)
joint
nom.cc(joint*attr(joint, "unit"))
}
