% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust.R
\name{step_robust}
\alias{step_robust}
\alias{tidy.step_robust}
\title{Perform Robust Scaling}
\usage{
step_robust(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  range = c(0.25, 0.75),
  res = NULL,
  columns = NULL,
  skip = FALSE,
  id = rand_id("robust")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[recipes:selections]{recipes::selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{range}{A numeric vector with 2 values denoting the lower and upper
quantile that is used for scaling. Defaults to \code{c(0.25, 0.75)}.}

\item{res}{A list containing the 3 quantiles of training variables is stored
here once this preprocessing step has be trained by \code{\link[recipes:prep]{recipes::prep()}}.}

\item{columns}{A character string of variable names that will be populated
(eventually) by the \code{terms} argument.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[recipes:bake]{bake()}}? While all operations are baked when \code{\link[recipes:prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the columns that will be affected) and \code{base}.
}
\description{
\code{step_robust()} creates a \emph{specification} of a recipe step that will perform
Robust scaling.
}
\details{
The scaling performed by this step is done using the following transformation

\deqn{x_new = (x - Q2(x)) / (Q3(x) - Q1(x))}

where \code{Q2(x)} is the median, \code{Q3(x)} is the upper quantile (defaults to 0.75)
and \code{Q1(x)} is the lower quantile (defaults to 0.25). The upper and lower
quantiles can be changed with the \code{range} argument.
}
\examples{
library(recipes)

rec <- recipe(~., data = mtcars) \%>\%
  step_robust(all_predictors()) \%>\%
  prep()

rec \%>\%
  bake(new_data = NULL)

tidy(rec, 1)

rec <- recipe(~., data = mtcars) \%>\%
  step_robust(all_predictors(), range = c(0.1, 0.9)) \%>\%
  prep()

rec \%>\%
  bake(new_data = NULL)

tidy(rec, 1)
}
