% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.kway.R
\name{srh.kway}
\alias{srh.kway}
\title{K-way SRH on ranks with tie-corrected p-values and rank-based effect sizes}
\usage{
srh.kway(formula, data, clamp0 = TRUE, force_factors = TRUE, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ A + B (+ C ...)}.}

\item{data}{A \code{data.frame} with the variables in \code{formula}.}

\item{clamp0}{Logical; if \code{TRUE} (default), negative \code{eta2H} is
truncated to 0 and \code{eps2H} truncated to the interval \eqn{[0, 1]}.}

\item{force_factors}{Logical; coerce grouping variables to \code{factor}
(default \code{TRUE}).}

\item{...}{Passed to \code{stats::lm()} if applicable.}
}
\value{
A \code{data.frame} with class \code{c("srh_kway","anova","data.frame")}
containing columns: \code{Effect}, \code{Df}, \code{Sum Sq}, \code{H},
\code{Hadj}, \code{p.chisq}, \code{k}, \code{n}, \code{eta2H}, \code{eps2H}.
The original call is attached as an attribute and can be retrieved with
\code{getCall()}.
}
\description{
Generalizes the Scheirer–Ray–Hare (SRH) approach to \emph{k}-factor designs
by using Type II sums of squares from a linear model on ranks, with a
standard tie correction \eqn{D} applied to p-values. The function returns
H, tie-corrected H (\code{Hadj}), \eqn{p}-values and rank-based effect sizes
(\code{eta2H}, \code{eps2H}) for each main effect and interaction up to the
full order (i.e., \code{(A + B + ...)^k}).
}
\details{
Ranks are computed globally on \code{y} (\code{ties.method = "average"}).
Type II sums of squares are obtained from \code{car::Anova(fit, type = 2)} on
the rank model \code{R ~ (A + B + ...)^k}. The tie correction is
\deqn{D = 1 - \frac{\sum (t^3 - t)}{n^3 - n},}
where \eqn{t} are tie block sizes and \eqn{n} is the number of complete
cases. We report \code{Hadj = H / D} and \eqn{p = P(\chi^2_{df} \ge Hadj)}.

Rank-based effect sizes are computed from the \emph{uncorrected} \code{H}
(classical SRH convention):
\itemize{
\item \code{eta2H = (H - k + 1) / (n - k)}, where \code{k} is the number of
groups compared by the term (for interactions, the number of observed
combinations),
\item \code{eps2H = H * (n + 1) / (n^2 - 1)} (KW-like epsilon squared).
}
}
\examples{
data(mimicry, package = "factorH")
# One factor (KW-style check)
srh.kway(liking ~ condition, data = mimicry)

# Two factors
srh.kway(liking ~ gender + condition, data = mimicry)

# Three factors
srh.kway(liking ~ gender + condition + age_cat, data = mimicry)

}
