% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{session_id_cookie}
\alias{session_id_cookie}
\title{Use a session cookie to store the id of the session}
\usage{
session_id_cookie(name = "fiery_id", secure = FALSE)
}
\arguments{
\item{name}{The name of the cookie to store the session id in}

\item{secure}{Should the session id only be send over HTTPS? Setting this to
TRUE will require setting up a proxy manager with SSL support in front of
your fiery server.}
}
\value{
A unary function taking a Request object and returning an ID for it
}
\description{
This function constructs an ID extractor for incoming requests, the return
value of which will be passed to the id argument of request, header, message
etc handlers. By default, fiery uses this with default arguments.
}
\details{
A session id is looked for in the cookie matching the \code{name} arg. If it is
found then the value of the cookie is returned. If it is not found then an
id is generated with \code{\link[reqres:random_key]{reqres::random_key()}} and attached to the response as
a cookie with the given name. The cookie is set to HTTP only and Strict same
site policy. Depending on \code{secure} it also sets it to only be transferred
over HTTPS.
}
\note{
Session ID should not be considered as authentication. If you are
handling sensitive data you should consider a more secure way of identifying
users across requests.
}
