% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fishtree_rogues}
\alias{fishtree_rogues}
\title{Get rogue taxa that break the monophyly of defined taxa}
\usage{
fishtree_rogues(rank)
}
\arguments{
\item{rank}{the (possibly paraphyletic) rank for which rogue or intruder species should be identified.}
}
\value{
A vector of species names, potentially empty.
}
\description{
For groups that were recovered as paraphyletic in the phylogenetic analysis,
uses the Fish Tree of Life API to identify which species prevented that clade
from being recovered as monophyletic.
}
\examples{
\dontrun{
fishtree_rogues("Gobiidae")   # several rogue taxa!
fishtree_rogues("Labridae")   # nice and monophlyetic
}
}
\references{
Rabosky, D. L., Chang, J., Title, P. O., Cowman, P. F., Sallan, L., Friedman, M., Kashner, K., Garilao, C., Near, T. J., Coll, M., Alfaro, M. E. (2018). An inverse latitudinal gradient in speciation rate for marine fishes. Nature, 559(7714), 392–395. doi:10.1038/s41586-018-0273-1
}
