% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{divide}
\alias{divide}
\alias{divide.pivot_table}
\title{Divide table}
\usage{
divide(pt)

\method{divide}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A \code{pivot_table} list.
}
\description{
Divides a table into tables separated by some empty row or column. Returns a
\code{pivot_table} object list.
}
\details{
Sometimes multiple pivot tables are placed in a text document, imported as
one text table. This operation recursively divides the initial table into
tables separated by some empty row or column. Once a division has been made,
it tries to divide each part of the result. An object is generated for each
indivisible pivot table. Returns a list of \code{pivot_table} objects.

If individual tables have a header or footer, they should not be separated
from the table by empty rows. If they were, objects would be generated from
them that must later be removed from the list of objects in the result.

The operation can be applied to tables located horizontally, vertically or in
a grid on the initial table. The only requirement to be able to divide it is
that there is some empty row or column between them.
}
\examples{

pt <- pivot_table(df_set_h_v)
lpt <- pt |> divide()

}
\seealso{
\code{\link{pivot_table}}

Other flat table list functions: 
\code{\link{flatten_table_list}()},
\code{\link{get_col_values}()}
}
\concept{flat table list functions}
