% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_regression_helper_functions.R
\name{compute_res}
\alias{compute_res}
\title{Compute Residuals for Fuzzy Linear Model}
\usage{
compute_res(Y_fuzzy, Y_pred)
}
\arguments{
\item{Y_fuzzy}{List. Fuzzified observed response variables.}

\item{Y_pred}{List. Fuzzified predicted response variables.}
}
\value{
A list of fuzzy residuals.
}
\description{
Compute Residuals for Fuzzy Linear Model
}
\examples{
# Example setup
Y_fuzzy <- list(
  list(l = 2, x = 3, r = 4),
  list(l = 5, x = 6, r = 7)
)
Y_pred <- list(
  list(l = 1.5, x = 2.5, r = 3.5),
  list(l = 4.5, x = 5.5, r = 6.5)
)

# Compute residuals
residuals <- compute_res(Y_fuzzy, Y_pred)
print(head(residuals, 6))
}
