# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Binary Vector to Bit
#'
#' Converts the first column of an integer matrix X
#' into its base 2 or bit representation. Used to speed up
#' Hamming distance vector computation.
#'
#' @param x (IntegerMatrix)
#' @return bit representation of first column (unsigned long long)
NULL

#' Fast Bitwise Hamming Distance Vector Computation
#'
#' Takes in a binary matrix \eqn{\mathbf{X}}, whose transpose \eqn{\mathbf{X}^T}
#' has \eqn{N} rows, and computes a vector recording all
#' \eqn{{N \choose 2}} pairwise Hamming distances of \eqn{\mathbf{X}^T},
#' ordered lexicographically.
#'
#' @param X binary matrix (IntegerMatrix class )
#' @return vector of Hamming distances (NumericVector class)
#' @examples # t(X) = [[1,0], [0,1], [1,1]] --> output = [2,1,1]
hamming_bitwise <- function(X) {
    .Call(`_flintyR_hamming_bitwise`, X)
}

#' Fast \eqn{l_p^p} Distance Vector Computation
#'
#' Takes in a double matrix \eqn{\mathbf{X}}, whose transpose \eqn{\mathbf{X}^T}
#' has \eqn{N} rows, and computes a vector recording all
#' \eqn{{N \choose 2}} pairwise \eqn{l_p^p} distances of \eqn{\mathbf{X}^T},
#' ordered lexicographically.
#'
#' @param X double matrix (arma::mat class)
#' @param p numeric Minkowski power (double class)
#' @return vector of \eqn{l_p^p} distances (arma::vec class)
#' @examples # X = [[0.5,0.5],[0,1],[0.3,0.7]] --> lPVec = [x,y,z]
#' # with x = (0.5^p + 0.5^p)
lp_distance <- function(X, p) {
    .Call(`_flintyR_lp_distance`, X, p)
}

