% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Convert Long-Format Distance Tibble to Matrix}
\usage{
distance_matrix(distances, distance_col = "fds")
}
\arguments{
\item{distances}{tibble with columns flow_ID_a, flow_ID_b, and distance}

\item{distance_col}{column name for distance (default "fds")}
}
\value{
distance matrix (tibble with rownames). The matrix has flow_ID_a as rownames and flow_ID_b as column names.
This function converts the output of \code{flow_distance()} into a format suitable for the \link[dbscan]{dbscan} clustering algorithm.
}
\description{
Convert Long-Format Distance Tibble to Matrix
}
\examples{
flows <- sf::st_transform(flows_leeds, 3857)
flows <- head(flows, 100) # for testing
# Add flow lengths and coordinates
flows <- add_flow_length(flows)
flows <- add_xyuv(flows)
# Calculate distances
distances <- flow_distance(flows, alpha = 1.5, beta = 0.5)
dmat <- distance_matrix(distances)
}
