% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_vars_template.R
\name{bs_vars_file}
\alias{bs_vars_file}
\title{Bootstrap variables from a file}
\usage{
bs_vars_file(input_file)
}
\arguments{
\item{input_file}{Path to SCSS file containing variables to use for creating a theme.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Bootstrap variables from a file
}
\examples{
my_vars <- file.path(tempdir(), "custom-vars.scss")
my_theme <- file.path(tempdir(), "theme.css")

# Open template and edit variables
use_vars_template(
  output_file = my_vars,
  theme = "flatly"
)

# Create new theme based on the modified template
create_theme(
  theme = "flatly",
  bs_vars_file(input_file = my_vars),
  output_file = my_theme
)


# Clean up
unlink(my_vars)
unlink(my_theme)
}
