% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{surf.sphere.dist}
\alias{surf.sphere.dist}
\title{Compute vertex neighborhoods on a sphere based on the given max distance along the sphere.}
\usage{
surf.sphere.dist(spherical_surface, maxdist)
}
\arguments{
\item{spherical_surface}{an fs.surface instance representing the spherical version (\code{lh.sphere} or \code{rh.sphere} of the subject).}

\item{maxdist}{double, the neighborhood size along the sphere, or to be more precise the maximal distance to travel along the sphere (using mesh edges) when searching for neighbors. The maxdist value can be computed from the definition of the Gaussian kernel parameters, i.e., its FWHM and truncation factor. See \code{pervertexdata.smoothgaussian} for an example of how to do that. Note that if the distance is smaller than the edge length, the neighborhoods for the vertices will only contain the vertex itself.}
}
\value{
named list with 3 entries. Each is a vector with neighborhood information: 'neigh' is an int vector of the neighbor vertices, 'neigh_dist_dotproduct' a numerical vector of dp distances for these neighbors, and 'neigh_dist_surface' the same for along-the-surface-distances instead of dp distances.
}
\description{
Compute neighborhood of the current vertex (=target vertex). The computation follows the mesh edges while there are still vertices which fullfil the dotproduct distance threshold. Alternatively, one could compute geodesic neighborhoods on the original mesh, but that is a lot slower. If no spherical surface is available, it has to be done though.
}
\examples{
\dontrun{
spherical_surface = subject.surface(fsaverage.path(), "fsaverage3",
  surface="sphere", hemi="lh");
sphere_dist = surf.sphere.dist(spherical_surface, 20.0);
highlight.vertices.on.subject(fsaverage.path(), "fsaverage3",
  verts_lh = sphere_dist$neigh[[500]], surface="sphere");
}

}
\keyword{internal}
