% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompleteRmap.R
\name{CompleteRmap}
\alias{CompleteRmap}
\title{Complete a Partially Specified Correlation Matrix by the Method of Alternating Projections}
\usage{
CompleteRmap(
  Rna,
  NMatrices = 1,
  RBounds = FALSE,
  LB = -1,
  UB = 1,
  delta = 1e-16,
  MinLambda = 0,
  MaxIter = 1000,
  detSort = FALSE,
  Parallel = FALSE,
  ProgressBar = FALSE,
  PrintLevel = 0,
  Digits = 3,
  Seed = NULL
)
}
\arguments{
\item{Rna}{(matrix) An n x n incomplete correlation matrix.  Missing entries must
be specified by NA values. If all off diagonal values are NA then the function
will generate a random correlation matrix.}

\item{NMatrices}{(integer) \code{CompleteRmap} will complete \code{NMatrices}
correlation matrices.}

\item{RBounds}{(logical) If \code{RBounds = TRUE} then the function will attempt to
produce a matrix on the surface of the associated elliptope (i.e., the space of all
possible PSD R matrices of a given dimension).
When \code{RBounds = FALSE}, during each cycle of the alternating projections
algorithm all negative eigenvalues of the provisional R matrix are replaced by
(sorted) uniform random numbers between the smallest positive eigenvalue and zero (inclusive) of the indefinite matrix.
Default \code{RBounds = FALSE}.}

\item{LB}{(numeric) The lower bound for the random number generator when generating
initial estimates for the missing elements of a partially specified correlation matrix.}

\item{UB}{(numeric) The upper bound for the random number generator when generating
initial estimates for the missing elements of a partially specified correlation matrix. Start values
(for missing correlations) are sampled from a uniform distribution with bounds \code{[LB, UB]}.}

\item{delta}{(numeric) A small number that controls the precision of the estimated solution.
Default \code{delta = 1E-16}.}

\item{MinLambda}{(numeric) A small value greater than or equal to 0  used to replace negative
eigenvalues during the modified alternating projections algorithm.}

\item{MaxIter}{(integer) The maximum number of cycles of the
alternating projections algorithm. Default \code{MaxIter = 1000}.}

\item{detSort}{(logical). If \code{detSort = TRUE} then all results will be sorted
according to the sizes of the matrix determinants (det(Ri)). Default \code{detSort = FALSE}}

\item{Parallel}{(logical). If \code{Parallel = TRUE} parallel processing will be used to
generate the completed correlation matrices. Default:  \code{Parallel = FALSE}.}

\item{ProgressBar}{(logical).  If \code{Parallel = TRUE} and \code{ProgressBar = TRUE} a progress bar
will be printed to screen. Default \code{ProgressBar = FALSE}.}

\item{PrintLevel}{(integer) The \code{PrintLevel} argument can take one of three values:
\itemize{
  \item 0  No output will be printed. Default (PrintLevel = 0).
  \item 1  Print \code{Delta} and the minimum eigenvalue of the currently completed correlation matrix.
  \item 2  Print convergence history.
  }}

\item{Digits}{(integer) Controls the number of printed significant digits if PrintLevel = 2.}

\item{Seed}{(integer) Initial random number seed. If reproducible results are desired then
it is necessary to specify  \code{ProgressBar = FALSE}. Default \code{Seed = NULL}.}
}
\value{
\itemize{
   \item  \strong{CALL} The function call.
   \item \strong{NMatrices} The number of completed R matrices.
   \item \strong{Rna} The input partially specified R matrix.
   \item  \strong{Ri} A list of the completed R matrices.
   \item \strong{RiEigs} A list of eigenvalues for each \code{Ri}.
   \item \strong{RiDet}  A list of the determinants for each \code{Ri}.
   \item \strong{converged} The convergence status (TRUE/FALSE) for each \code{Ri}.
}
}
\description{
This function completes a (possibly) partially specified
correlation matrix by a modified alternating projections algorithm.
}
\examples{
\dontrun{
Rna4 <- matrix(c( 1,  NA,  .29, .18,
                  NA, 1,   .11, .24,
                 .29, .11, 1,   .06,
                 .18, .24, .06, 1), 4, 4)

Out4  <- CompleteRmap(Rna = Rna4,
                      NMatrices = 5,
                      RBounds = FALSE,
                      LB = -1,
                      UB = 1,
                      delta = 1e-16,
                      MinLambda = 0,
                      MaxIter = 5000,
                      detSort = FALSE,
                      ProgressBar = TRUE,
                      Parallel = TRUE,
                      PrintLevel = 1,
                      Digits = 3,
                      Seed = 1)

summary(Out4,
        PrintLevel = 2,
        Digits = 5)
}
}
\references{
Higham, N. J.  (2002).  Computing the nearest correlation matrix: A problem
from finance.  IMA Journal of Numerical Analysis, 22(3), 329--343.

Waller, N. G.  (2020).  Generating correlation matrices with specified
eigenvalues using the method of alternating projections.
The American Statistician, 74(1), 21-28.
}
\author{
Niels G. Waller
}
